/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.Range;
import weka.filters.AbstractFilterTest;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.PartitionedMultiFilter;

public class PartitionedMultiFilterTest
extends AbstractFilterTest {
    public PartitionedMultiFilterTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.deleteAttributeType(2);
        this.m_Instances.deleteAttributeType(4);
    }

    @Override
    public Filter getFilter() {
        return new PartitionedMultiFilter();
    }

    protected Instances applyFilter(Filter[] filters, Range[] ranges, boolean remove) throws Exception {
        PartitionedMultiFilter filter = (PartitionedMultiFilter)this.getFilter();
        filter.setFilters(filters);
        filter.setRanges(ranges);
        filter.setRemoveUnused(remove);
        filter.setInputFormat(this.m_Instances);
        Instances result = Filter.useFilter(this.m_Instances, filter);
        return result;
    }

    public void testDisjoint() {
        Instances result = null;
        this.m_Instances.setClassIndex(2);
        try {
            result = this.applyFilter(new Filter[]{new AllFilter(), new AllFilter()}, new Range[]{new Range("1-2"), new Range("4-5")}, false);
        }
        catch (Exception e) {
            PartitionedMultiFilterTest.fail("Problem applying the filter: " + e);
        }
        PartitionedMultiFilterTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        PartitionedMultiFilterTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
    }

    public void testDisjointRemoveUnused() {
        Instances result = null;
        this.m_Instances.setClassIndex(2);
        try {
            result = this.applyFilter(new Filter[]{new AllFilter(), new AllFilter()}, new Range[]{new Range("1-2"), new Range("5")}, true);
        }
        catch (Exception e) {
            PartitionedMultiFilterTest.fail("Problem applying the filter: " + e);
        }
        PartitionedMultiFilterTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        PartitionedMultiFilterTest.assertEquals(this.m_Instances.numAttributes() - 1, result.numAttributes());
    }

    public void testOverlapping() {
        Instances result = null;
        this.m_Instances.setClassIndex(2);
        try {
            result = this.applyFilter(new Filter[]{new AllFilter(), new AllFilter()}, new Range[]{new Range("1,2,4"), new Range("2,4")}, false);
        }
        catch (Exception e) {
            PartitionedMultiFilterTest.fail("Problem applying the filter: " + e);
        }
        PartitionedMultiFilterTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        PartitionedMultiFilterTest.assertEquals(this.m_Instances.numAttributes() + 2, result.numAttributes());
    }

    public void testOverlappingRemoveUnused() {
        Instances result = null;
        this.m_Instances.setClassIndex(2);
        try {
            result = this.applyFilter(new Filter[]{new AllFilter(), new AllFilter()}, new Range[]{new Range("1,2,4"), new Range("2,4")}, true);
        }
        catch (Exception e) {
            PartitionedMultiFilterTest.fail("Problem applying the filter: " + e);
        }
        PartitionedMultiFilterTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        PartitionedMultiFilterTest.assertEquals(this.m_Instances.numAttributes() + 1, result.numAttributes());
    }

    public static Test suite() {
        return new TestSuite(PartitionedMultiFilterTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(PartitionedMultiFilterTest.suite());
    }
}

